@props([
    'package',
    'data',
])
<div class="card sidePartials">
    <div class="card-header">
        <h4>@lang("app.booking-info")</h4>
    </div>
    <div class="card-body">
        <div class="section-header">
            <div class="image-area">
                <img src="{{asset($package->thumbnail)}}" alt="{{$package->name}}">
            </div>
            <div class="content-area">
                <h5 class="title">{{$package->name}} </h5>
                <span class="location"><i class="fa-regular fa-location-dot"></i>{{$package->destination->location}}</span>
            </div>
        </div>
        <ul class="cmn-list pt-3">
            <li class="item">
                <h6>@lang('app.package_type')</h6>
                <h6>@lang($package->category->name)</h6>
            </li>
            <li class="item">
                <h6>@lang('app.departure-date')</h6>
                <h6><span class="updated-date">{{$package->start_date->format('D m, Y')}}</span></h6>
            </li>
            <li class="item">
                <h6>@lang('app.duration')</h6>
                <h6>{{$package->duration}}</h6>
            </li>
            <li class="item">
                <h6>@lang('app.num-of-adults')</h6>
                <h6>{{$data['adult']}}</h6>
            </li>
            <li class="item">
                <h6>@lang('app.num-of-children')</h6>
                <h6>{{$data['child']}}</h6>
            </li>
            <li class="item">
                <h6>@lang('app.num-of-infants')</h6>
                <h6>{{$data['infant']}}</h6>
            </li>
        </ul>
        <div class="checkout-summary">
            <div class="widget-title">
                <h4 class="title discount">@lang('app.price-summary')</h4>
            </div>
            <div class="cart-total">
                <ul>
                    <li class="d-flex justify-content-between">
                        <span>@lang('app.total-price')</span>
                        <span>৳{{number_format($data['amount'], 2)}}</span>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
